/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.summary.VWMilestoneHistoryPanel;
import filenet.vw.toolkit.runtime.summary.VWSummaryInfoPanel;
import filenet.vw.toolkit.runtime.summary.VWWorkItemPanel;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.utils.VWDriverFrame;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWTrackerSummaryInfo
extends JPanel
implements ItemListener,
ItemSelectable,
ChangeListener,
IVWPropertyChangeSource {
    protected Frame m_parentFrame = null;
    protected VWTrkDataModel m_trackerDataModel = null;
    protected ItemListener m_selectListeners = null;
    private JTabbedPane m_tabbedPane = null;
    private VWMilestoneHistoryPanel m_milestoneTab = null;
    private VWWorkItemPanel m_workItemTab = null;
    private VWSummaryInfoPanel m_workflowTab = null;
    private Vector m_mapTabs = null;
    private VWSummaryInfoPanel m_stepTab = null;

    public static void main(String[] args) {
        VWDriverFrame frame = null;
        VWTrackerSummaryInfo panel = null;
        try {
            frame = new VWDriverFrame();
            frame.setSize(400, 300);
            panel = new VWTrackerSummaryInfo(null, null);
            frame.add((Component)panel, "Center");
            frame.show();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWTrackerSummaryInfo(Frame parentFrame, VWTrkDataModel trackerDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_trackerDataModel = trackerDataModel;
        this.setLayout(new BorderLayout(0, 0));
        this.m_tabbedPane = new JTabbedPane(3){

            public void addNotify() {
                super.addNotify();
                Font boldFont = null;
                Font font = null;
                font = this.getFont();
                if (font != null && (boldFont = new Font(font.getName(), 1, font.getSize())) != null) {
                    this.setFont(boldFont);
                }
            }
        };
        this.m_tabbedPane.setTabPlacement(3);
        this.add((Component)this.m_tabbedPane, "Center");
        this.m_tabbedPane.addChangeListener(this);
    }

    public void initialize() {
        if (this.m_trackerDataModel.getMilestones() != null && this.m_trackerDataModel.getMilestones().size() > 0) {
            this.m_milestoneTab = new VWMilestoneHistoryPanel(this.m_parentFrame, this, this.m_trackerDataModel);
            this.m_tabbedPane.add((Component)this.m_milestoneTab, VWResource.s_milestones);
            this.m_milestoneTab.initialize();
        }
        this.m_workflowTab = new VWSummaryInfoPanel(this.m_parentFrame, this, this.m_trackerDataModel, -1, true);
        this.m_tabbedPane.add((Component)this.m_workflowTab, VWResource.s_workflowHistory);
        this.m_workflowTab.initialize();
        this.m_tabbedPane.addChangeListener(this.m_workflowTab);
        Vector maps = this.m_trackerDataModel.getMaps();
        VWTrkMap map = null;
        this.m_mapTabs = new Vector();
        Object mapTab = null;
        for (int i = 0; i < maps.size(); ++i) {
            Object obj = maps.elementAt(i);
            if (obj == null || !(obj instanceof VWTrkMap) || !(map = (VWTrkMap)obj).isMainmap()) continue;
            this.m_stepTab = new VWSummaryInfoPanel(this.m_parentFrame, this, this.m_trackerDataModel, map.getMapId(), false);
        }
        if (this.m_stepTab != null) {
            this.m_tabbedPane.addTab(VWResource.s_stepHistory, this.m_stepTab);
            this.m_tabbedPane.addChangeListener(this.m_stepTab);
        }
        if (this.m_stepTab != null) {
            this.m_stepTab.initialize();
        }
        this.m_workItemTab = new VWWorkItemPanel(this.m_parentFrame, this, this.m_trackerDataModel);
        this.m_tabbedPane.add((Component)this.m_workItemTab, VWResource.s_workItems);
        this.m_workItemTab.initialize();
        this.m_tabbedPane.addChangeListener(this.m_workItemTab);
    }

    VWSummaryInfoPanel getMapTab(int mapId) {
        if (this.m_mapTabs != null) {
            Object obj = null;
            VWSummaryInfoPanel mapTab = null;
            for (int i = 0; i < this.m_mapTabs.size(); ++i) {
                obj = this.m_mapTabs.elementAt(i);
                if (obj == null || !(obj instanceof VWSummaryInfoPanel) || (mapTab = (VWSummaryInfoPanel)obj).getMapId() != mapId) continue;
                return mapTab;
            }
        }
        return null;
    }

    void displayMap(VWTrkMap map, boolean bRemainTabSelection) {
        int tab = this.m_tabbedPane.getSelectedIndex();
        this.notifySelectListeners(new ItemEvent(this, 0, map, 1));
        if (bRemainTabSelection && this.m_tabbedPane.getSelectedIndex() != tab) {
            this.m_tabbedPane.setSelectedIndex(tab);
        }
    }

    void displayStep(VWTrkStep step, boolean bRemainTabSelection) {
        if (this.m_trackerDataModel != null && step != null) {
            int tab = this.m_tabbedPane.getSelectedIndex();
            VWTrkMap map = this.m_trackerDataModel.getMap(step.getMapId());
            if (map != null) {
                this.displayMap(map, false);
            }
            this.notifySelectListeners(new ItemEvent(this, 0, step, 1));
            if (bRemainTabSelection && this.m_tabbedPane.getSelectedIndex() != tab) {
                this.m_tabbedPane.setSelectedIndex(tab);
            }
        }
    }

    void displayStepOccurrence(VWTrkStepOccurrence occurrence, boolean bRemainTabSelection) {
        if (this.m_trackerDataModel != null && occurrence != null) {
            int tab = this.m_tabbedPane.getSelectedIndex();
            VWTrkStep step = occurrence.getStep();
            if (step != null) {
                step.setSelectedOccurrenceIndex(occurrence.getOccurrenceIndex());
                this.displayStep(step, false);
                this.notifyPropertyChange();
                if (bRemainTabSelection && this.m_tabbedPane.getSelectedIndex() != tab) {
                    this.m_tabbedPane.setSelectedIndex(tab);
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        boolean bStepSelected = false;
        Vector<VWTrkStep> selectedSteps = new Vector<VWTrkStep>();
        ItemSelectable itemSelectable = e.getItemSelectable();
        Object[] objects = itemSelectable.getSelectedObjects();
        if (objects != null && objects.length > 0) {
            Object obj0 = objects[0];
            for (int i = 0; i < objects.length; ++i) {
                VWTrkStep step;
                Object obj = objects[i];
                if (i != 0 && obj == obj0 || !(obj instanceof VWMapNode) || (step = this.m_trackerDataModel.findStep(((VWMapNode)obj).getStepId())) == null) continue;
                if (!step.isLaunchStep()) {
                    bStepSelected = true;
                }
                selectedSteps.addElement(step);
            }
        }
        if (this.m_stepTab != null) {
            this.m_stepTab.selectSteps(selectedSteps);
            if (bStepSelected && e.getID() != 100) {
                this.m_tabbedPane.setSelectedComponent(this.m_stepTab);
            } else {
                Component obj = this.m_tabbedPane.getSelectedComponent();
                VWSummaryInfoPanel selectedTab = null;
                if (obj != null && obj instanceof VWSummaryInfoPanel && (selectedTab = (VWSummaryInfoPanel)obj).isMapPanel()) {
                    VWSummaryInfoPanel mapTab;
                    int activeMapId = this.m_trackerDataModel.getSelectedMap().getMapId();
                    if (selectedTab.getMapId() != activeMapId && (mapTab = this.getMapTab(activeMapId)) != null) {
                        this.m_tabbedPane.setSelectedComponent(mapTab);
                    }
                }
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Component obj;
        if (e.getSource() == this.m_tabbedPane && (obj = this.m_tabbedPane.getSelectedComponent()) != null && obj instanceof VWSummaryInfoPanel && ((VWSummaryInfoPanel)obj).isMapPanel()) {
            this.notifySelectListeners(new ItemEvent(this, 0, ((VWSummaryInfoPanel)obj).getMap(), 1));
        }
    }

    public synchronized void addItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, l);
    }

    public Object[] getSelectedObjects() {
        Component obj = this.m_tabbedPane.getSelectedComponent();
        if (obj != null && obj instanceof VWSummaryInfoPanel && ((VWSummaryInfoPanel)obj).isMapPanel()) {
            Object[] objArray = new Object[]{((VWSummaryInfoPanel)obj).getMapName()};
            return objArray;
        }
        return null;
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, l);
    }

    protected void notifySelectListeners(ItemEvent event) {
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public void notifyPropertyChange() {
        VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, 702));
    }

    public Vector getItemsChanged() {
        return this.m_trackerDataModel.getSelectedMap().getSelectedSteps();
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_trackerDataModel = null;
        this.m_selectListeners = null;
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.removeChangeListener(this);
            this.m_tabbedPane.removeChangeListener(this.m_workflowTab);
            this.m_tabbedPane.removeChangeListener(this.m_stepTab);
            this.m_tabbedPane.removeChangeListener(this.m_workItemTab);
            for (int i = this.m_tabbedPane.getTabCount() - 1; i >= 0; --i) {
                this.m_tabbedPane.removeTabAt(i);
            }
            this.m_tabbedPane.removeAll();
            this.m_tabbedPane = null;
        }
        if (this.m_milestoneTab != null) {
            this.m_milestoneTab.removeReferences();
            this.m_milestoneTab = null;
        }
        if (this.m_workItemTab != null) {
            this.m_workItemTab.removeReferences();
            this.m_workItemTab = null;
        }
        if (this.m_workflowTab != null) {
            this.m_workflowTab.removeReferences();
            this.m_workflowTab = null;
        }
        if (this.m_stepTab != null) {
            this.m_stepTab.removeReferences();
            this.m_stepTab = null;
        }
        if (this.m_mapTabs != null) {
            Object obj = null;
            VWSummaryInfoPanel mapTab = null;
            for (int i = 0; i < this.m_mapTabs.size(); ++i) {
                obj = this.m_mapTabs.elementAt(i);
                if (obj == null || !(obj instanceof VWSummaryInfoPanel)) continue;
                mapTab = obj;
                mapTab.removeReferences();
            }
            this.m_mapTabs.removeAllElements();
            this.m_mapTabs = null;
        }
        this.removeAll();
    }
}

